// insertSort.java
// demonstruje sortowanie przez wstawianie
// uruchomienie programu: C>java InsertSortApp
//--------------------------------------------------------------
class ArrayIns
   {
   private long[] a;                 // referencja do tablicy
   private int nElems;               // licznik elementw tablicy
//--------------------------------------------------------------
   public ArrayIns(int max)          // konstruktor
      {
      a = new long[max];                 // tworzymy tablic
      nElems = 0;                        // na razie brak elementw
      }
//--------------------------------------------------------------
   public void insert(long value)    // wstawienie elementu do tablicy
      {
      a[nElems] = value;             // wstawienie elementu
      nElems++;                      // zwikszenie licznika
      }
//--------------------------------------------------------------
   public void display()             // wypisuje elementy tablicy
      {
      for(int j=0; j<nElems; j++)       // dla kadego elementu...
         System.out.print(a[j] + " ");  // ...wypisujemy jego warto
      System.out.println("");
      }
//--------------------------------------------------------------
   public void insertionSort()
      {
      int in, out;

      for(out=1; out<nElems; out++)     // out to pierwszy nieposortowany element
         {
         long temp = a[out];            // kopiujemy wyrniony element
         in = out;                      // zaczynamy od out
         while(in>0 && a[in-1] >= temp) // dopki elementy s wiksze ni temp
            {
            a[in] = a[in-1];            // przesuwamy elementy w prawo
            --in;                       // przesuwamy si w lewo
            }
         a[in] = temp;                  // wstawiamy wyrniony element
         }  // koniec ptli for
      }  // koniec insertionSort()
//--------------------------------------------------------------
   }  // koniec klasy ArrayIns
////////////////////////////////////////////////////////////////
class InsertSortApp
   {
   public static void main(String[] args)
      {
      int maxSize = 100;            // rozmiar tablicy
      ArrayIns arr;                 // referencja do tablicy
      arr = new ArrayIns(maxSize);  // tworzymy tablic

      arr.insert(77);               // wstawiamy 10 elementw
      arr.insert(99);
      arr.insert(44);
      arr.insert(55);
      arr.insert(22);
      arr.insert(88);
      arr.insert(11);
      arr.insert(00);
      arr.insert(66);
      arr.insert(33);

      arr.display();                // wypisujemy elementy

      arr.insertionSort();          // sortujemy je

      arr.display();                // i znw wypisujemy
      }  // koniec main()
   }  // koniec klasy InsertSortApp
////////////////////////////////////////////////////////////////
